package benchmarks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import com.thoughtworks.xstream.XStream;

public class XStreamLib implements TestMethods{
	
	public static XStream xstream;
	public XStreamLib(){
		xstream = new XStream();
	}

	@Override
	public byte[] serialize(Object o) throws IOException {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		xstream.toXML(o, out);
		return out.toByteArray();
	}

	@Override
	public Object deserialize(byte[] b, Class c) throws IOException,
			ClassNotFoundException {
		ByteArrayInputStream in = new ByteArrayInputStream(b);		
		return xstream.fromXML(in);
	}

	@Override
	public Object copy(Object o) throws IOException, ClassNotFoundException {
		return deserialize(serialize(o), o.getClass());
	}

}
